; PLUGIN STEP 10: VISUALIZATION METHOD

(defmeth vista-RewCat-proto  :visualize ()
  (setf container (make-container :free t :type 1 :local-menus t :show nil))
  (enable-container container)
  (let*
    (
     (v-rewcat-proto self)
     (terms (expand-hierarchy 
             (list (iseq (length (send self :vars))))))
     (terms-cat (send self :list-terms))
     (terms-in-model-name-list 
      (name-list 
       (mapcar 'princ-to-string terms-cat) :vertical nil :help-only t :show nil))
     (obs-list
      (name-list 
       (mapcar 'princ-to-string (send self :labels))
       :color 'blue))
     (number-vars (length (send self :vars)))
     (predicted-residual (plot-points (list
                        	 (send (send self :curr-model) :fit-values)
                                       (send (send self :curr-model)
                              	 :residuals)
                        	 (send (send self :curr-model)
                              	 :externally-studentized-residuals)
                                       (send v-rewcat-proto :y-vector)
                          (send (send self :curr-model) :studentized-residuals))
                          :variable-labels (list "Predicted Values" "Raw-residuals" "Ext-Std-residuals" "Observed values" "Studentized Residuals")
                                 :color 'blue 
                      :show nil))
     (cook-plot (scatterplot (send (send self :curr-model) :leverages)
                             (send v-rewcat-proto
                                   :cooks-distances)
                             :variable-labels (list "Leverages" "Cooks distances")
                             
                             :color 'blue :show nil))
     (dev-plot (scatterplot (list 1) 
                            (list (send (send self :curr-model)
                                        :r-squared) )
                            :variable-labels (list "Model" "R-squared")
                            :show nil))
     (par-plot (send self :parametters-plot))
     (w (send display-window-proto2 :new :pop-out-on-show t :show nil ))
     )
   

  (mapcar #'(lambda (plot)
              (send plot :point-label (iseq (send plot :num-points)) 
                    (send self :labels))
              (send plot :vista-look-and-feel)
              (send plot :point-symbol (iseq (send plot :num-points)) 'dot4)
              (send plot :point-color (iseq (send plot :num-points)) 'black)
              )
           (list predicted-residual cook-plot))
    
    (send dev-plot :plot-buttons  :new-x nil :new-y nil)
            (send dev-plot :x-axis t t 0)
    (send dev-plot :plot-buttons :mouse-mode nil)
    (send dev-plot :mouse-mode 'selecting)
    (send dev-plot :delete-mouse-mode 'brushing)
    (send dev-plot :add-points (list 1) (list (send (send self :curr-model) :adjusted-r-squared)))
    (send dev-plot :range 1 0 1)
    (send cook-plot :range 0 0 1)
  #|  (defmeth cook-plot :add-limit-lines ()
      (let* ((ncat (length (send v-rewcat-proto :y-vector)))
             (lim-lev (/ (send (send v-rewcat-proto :curr-model) 
                                 :num-coefs)
                         ncat))
             (max-cook (max (send (send v-rewcat-proto :curr-model)  :cooks-distances)))
             (lim-cook (/  ncat 4)) 
             )
          (send self :clear-lines)
        (send self :range 1 0 (max max-cook lim-cook))
          (send self  :add-lines (list lim-lev lim-lev) 
                (list 0 (max max-cook lim-cook)) :color 'orange)
          (send self :add-lines (list 0 1) (list lim-cook lim-cook) :color 'orange))
      )
    (send cook-plot :add-limit-lines)|#
    (send self :define-model-terms-window terms-in-model-name-list terms)

    (send dev-plot :legend2 "R-Square Plot")
    (send cook-plot :legend2 "Influence Plot")
    (send predicted-residual :legend2 "Predicted-Residual Plot")
   
    (send v-rewcat-proto :be-hierarchic? t)
    (send obs-list :has-h-scroll t)
    (defmeth dev-plot :redraw ()
      (call-next-method)
      (send self :abline 1 0 :color 'green))
   
(defmeth predicted-residual :update-plotcell (&rest args)
  (send self :start-buffering)
  (setf cvar (send self :current-variables))
  (cond
    ((and (equal (first args) "dev-plot") (= (length (combine (third args))) 1))
     (send self :my-new-plot (list                       
                              (send (send v-rewcat-proto :curr-model) :fit-values)
                              (send (send v-rewcat-proto :curr-model) :residuals)
                              (send (send v-rewcat-proto :curr-model)  :externally-studentized-residuals)
                              (send v-rewcat-proto :y-vector)
                              (send (send v-rewcat-proto :curr-model)  :studentized-residuals)))
     )
    ((equal (first args) "terms")
     (send self :my-new-plot (list     
                              (send (send v-rewcat-proto :curr-model) :fit-values)
                              (send (send v-rewcat-proto :curr-model) :residuals)
                              (send (send v-rewcat-proto :curr-model)  :externally-studentized-residuals)
                              (send v-rewcat-proto :y-vector)
                              (send (send v-rewcat-proto :curr-model)  :studentized-residuals)))
     
     ))
  (apply 'send self :current-variables cvar )
  (send self :adjust-to-data)
  (if (> (max (mapcar 'abs (send self :range 1))) 3)
      (send self :adjust-to-data)
      (send self :range 1 -3 3))
  (send self :buffer-to-screen)
  )
    
#|    (defmeth count-residual :update-plotcell (&rest args)
      (send self :start-buffering)
      (cond
        ((and (equal (first args) "dev-plot") (= (length (combine (third args))) 1))
         (send self :my-new-plot (send v-log-lin-proto  :counts)
               (send (send v-log-lin-proto :curr-model)  :adj-chi-residuals) )
                 )
        ((equal (first args) "terms")
         (send self :my-new-plot (send v-log-lin-proto :counts)
             (send (send v-log-lin-proto :curr-model)  :adj-chi-residuals))))
      (send self :adjust-to-data)
            (if (> (max (mapcar 'abs (send self :range 1))) 3)
          (send self :adjust-to-data)
          (send self :range 1 -3 3))
      (send self :buffer-to-screen)
      )|#

    (defmeth cook-plot :update-plotcell (&rest args)
      (send self :start-buffering)
      (let (
            (leverages (send (send v-rewcat-proto :curr-model) :leverages))
            (cook-dist  (send v-rewcat-proto :cooks-distances))
            )
        (cond
          ((and (equal (first args) "dev-plot") (= (length (combine (third args))) 1))
           (send self :my-new-plot leverages
                 cook-dist))
          
          
          ((equal (first args) "terms")
           (send self :my-new-plot (send (send v-rewcat-proto :curr-model) :leverages)
                 (send v-rewcat-proto  :cooks-distances))
           ))
        (send self :adjust-to-data)
        (send self :range 0 0 1)
        (send self :buffer-to-screen)
        ))
    
   (defmeth w :update-plotcell (&rest args)
      (send self :flush-window)
      (add-text w (princ-to-string (send (send v-rewcat-proto :curr-model) :r-squared))))



    (defmeth dev-plot :update-plotcell (&rest args)
     
      
      (when (equal (first args) "terms")
            (send self :start-buffering)
            (send self :clear-points)
            (send self :add-points 
                 (iseq (length (send v-rewcat-proto :models-adjusted-list)))
                  (mapcar #'(lambda (obj) (send obj :r-squared))
                         (send v-rewcat-proto :models-adjusted-list))
                  :color 'blue)
            (send self :add-lines 
                (iseq (length (send v-rewcat-proto :models-adjusted-list)))
                  (mapcar #'(lambda (obj) (send obj :r-squared))
                        (send v-rewcat-proto :models-adjusted-list))
                  :color 'red)
            (send self :add-lines 
                (iseq (length (send v-rewcat-proto :models-adjusted-list)))
                  (mapcar #'(lambda (obj) (send obj :adjusted-r-squared))
                        (send v-rewcat-proto :models-adjusted-list))
                  :color 'green)
            (send self :adjust-to-data)
            (send self :range 1 0 1)
            (send self :buffer-to-screen))
            )
      
    (defmeth dev-plot :do-click (x y m1 m2)
      (call-next-method x y m1 m2)
      (let* (  
               (hilited (send self :selection)))
             ;(num-points (send self :selection)
             ;(hilited (mapcar #'(lambda (h) (equal h 'HILITED)) (send self :point-state (iseq num-points))))
                        
        

      (when (and hilited
                 (= (length hilited) 1))
            (send v-rewcat-proto :curr-model 
                  (select  (send v-rewcat-proto :models-adjusted-list) 
                           (first hilited)))
            )
      (send (send self :spreadplot-object)
            :update-spreadplot "dev-plot" 0 hilited)
     
     
      ))





   (setf sp (spread-plot 
              (matrix '(2 4) 
                      (list 
                       terms-in-model-name-list
                       predicted-residual
                       cook-plot
                       obs-list
                       nil
                       dev-plot
                       par-plot
                       nil
                       ))
             :span-down (matrix '(2 4) (list 2 1 1 2 0 1 1 0))
             :rel-widths (list 0.5 1 1 0.5)
             :local-links t
             :container container))

 
    (send sp :show-spreadplot)
    (send sp :supplemental-plot w)
    (defmeth w :close ()
      (send self :hide-window))
   ; (send w  :update-plotcell "terms" nil nil)
    (send dev-plot  :update-plotcell "terms" nil nil)
    (defmeth sp :refresh ()
      (call-next-method)
      (send w :show-window)
      (send w :top-most t))
    (send w :size 339 75)
    (send w :show-window)
    (send w :top-most t)
    (send cook-plot :linked t)
    (send obs-list :linked t)
	(send predicted-residual :linked t)
    (disable-container)
    ))

    